<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Twig;

use Dedi\SyliusMarketingPlugin\Provider\GoogleTagIdProviderInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class GoogleTagIdExtension extends AbstractExtension
{
    private GoogleTagIdProviderInterface $googleTagIdProvider;

    public function __construct(GoogleTagIdProviderInterface $googleTagIdProvider)
    {
        $this->googleTagIdProvider = $googleTagIdProvider;
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('get_google_tag_id', [$this, 'getGoogleTagId']),
        ];
    }

    public function getGoogleTagId(): string
    {
        return $this->googleTagIdProvider->provide() ?? '';
    }
}
