<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Twig;

use Dedi\SyliusMarketingPlugin\Events\EventInterface;
use Dedi\SyliusMarketingPlugin\Storage\EventStorageInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class EventsExtension extends AbstractExtension
{
    private EventStorageInterface $eventStorage;

    public function __construct(EventStorageInterface $eventStorage)
    {
        $this->eventStorage = $eventStorage;
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('fetch_events', [$this, 'fetchEvents']),
        ];
    }

    public function fetchEvents(): array
    {
        $syncEvents = $this->eventStorage->getSyncEvents();

        /** @var EventInterface $syncEvent */
        foreach ($syncEvents as $syncEvent) {
            $this->eventStorage->removeSyncEvent($syncEvent->getUniqId());
            $this->eventStorage->removeAsyncEvent($syncEvent->getUniqId());
        }

        return $syncEvents;
    }
}
