<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Twig;

use Dedi\SyliusMarketingPlugin\Provider\UserProviderInterface;
use Sylius\Component\Core\Model\ShopUserInterface;
use Symfony\Component\Security\Core\Authentication\Token\Storage\TokenStorageInterface;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class DatalayerExtension extends AbstractExtension
{
    private TokenStorageInterface $tokenStorage;

    private UserProviderInterface $userProvider;

    public function __construct(
        TokenStorageInterface $tokenStorage,
        UserProviderInterface $userProvider,
    ) {
        $this->tokenStorage = $tokenStorage;
        $this->userProvider = $userProvider;
    }

    public function getFunctions(): array
    {
        return [
            new TwigFunction('get_user_data', [$this, 'getUserData']),
        ];
    }

    public function getUserData(): array
    {
        $token = $this->tokenStorage->getToken();

        $user = null;
        if ($token instanceof TokenInterface) {
            $user = $token->getUser();
        }

        if (!$user instanceof ShopUserInterface) {
            return [];
        }

        return $this->userProvider->getUserData($user->getCustomer());
    }
}
