<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Storage;

use Dedi\SyliusMarketingPlugin\Provider\TaxonProviderInterface;
use Sylius\Component\Core\Model\TaxonInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestStack;

class TaxonNavigationHistoryManager implements TaxonNavigationHistoryManagerInterface
{
    private SessionManagerInterface $sessionManager;

    private TaxonProviderInterface $taxonProvider;

    private RequestStack $requestStack;

    public function __construct(
        SessionManagerInterface $sessionManager,
        TaxonProviderInterface $taxonProvider,
        RequestStack $requestStack,
    ) {
        $this->sessionManager = $sessionManager;
        $this->taxonProvider = $taxonProvider;
        $this->requestStack = $requestStack;
    }

    public function storeLastSeenTaxon(): void
    {
        $request = $this->requestStack->getCurrentRequest();

        if (!$request instanceof Request) {
            return;
        }

        $slug = $request->get('slug');
        $taxon = $this->taxonProvider->getTaxonBySlug($slug);

        if (!$taxon instanceof TaxonInterface) {
            return;
        }

        $this->sessionManager->add(SessionManagerInterface::LAST_TAXON_KEY_SUFFIX, [
            'slug' => $taxon->getSlug(),
        ]);
    }
}
