<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Storage;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Session\SessionInterface;

class SessionManager implements SessionManagerInterface
{
    private RequestStack $requestStack;

    public function __construct(RequestStack $requestStack)
    {
        $this->requestStack = $requestStack;
    }

    public function set(string $key, array $data): void
    {
        $session = $this->getSession();
        if (null === $session) {
            return;
        }
        $session->set($key, $data);
    }

    public function add(string $key, array $data): void
    {
        $session = $this->getSession();
        if (null === $session) {
            return;
        }
        $storedData = $session->get($key) ?? [];
        $session->set($key, array_merge($storedData, $data));
    }

    public function get(string $key)
    {
        $session = $this->getSession();
        if (null === $session) {
            return null;
        }

        return $session->get($key);
    }

    public function remove(string $key): void
    {
        $session = $this->getSession();
        if (null === $session) {
            return;
        }
        $session->remove($key);
    }

    private function getSession(): ?SessionInterface
    {
        $currentRequest = $this->requestStack->getCurrentRequest();
        if (!$currentRequest instanceof Request) {
            return null;
        }

        return $currentRequest->getSession();
    }
}
