<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Storage;

use Dedi\SyliusMarketingPlugin\Events\EventInterface;

interface EventStorageInterface
{
    public function store(EventInterface $event): void;

    public function getSyncEvents(): array;

    public function getAsyncEvents(): array;

    public function clear(): void;

    public function removeAsyncEvent(string $key): void;

    public function removeSyncEvent(string $key): void;
}
