<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Specification;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Dedi\SyliusMarketingPlugin\DependencyInjection\Settings\SettingsInterface;
use Dedi\SyliusMarketingPlugin\Events\EventInterface;

class IsAsyncEvent
{
    private SettingsProviderInterface $settingsProvider;

    public function __construct(SettingsProviderInterface $settingsProvider)
    {
        $this->settingsProvider = $settingsProvider;
    }

    public function isSatisfiedBy(EventInterface $event): bool
    {
        /** @var SettingsInterface $settings */
        $settings = $this->settingsProvider->provide();

        return in_array($event->getName(), $settings->getAsyncEvents(), true);
    }
}
