import bindSelectItemEventListeners from "./components/select-item";
import AsyncEventsHandler from "./components/async-events";

document.addEventListener('DOMContentLoaded', () => {
  bindSelectItemEventListeners();

  let triggersConfig = document.querySelector('#dedi_sylius_marketing_async_triggers').dataset;
  let triggers = JSON.parse(triggersConfig.triggers);
  let url = triggersConfig.target;
  let asyncConfig = JSON.parse(triggersConfig.asyncConfig);

  let asyncEventsHandler = new AsyncEventsHandler(
    asyncConfig,
    window.dataLayer || [],
    triggers,
    url
  );
  asyncEventsHandler.bindEventListeners();
});
