export default function bindSelectItemEventListeners() {
  document.querySelectorAll('[data-select-item]').forEach((item) => {
    item.querySelectorAll('a[href]').forEach((link) => {
      link.addEventListener('click', (event) => {
        event.preventDefault();
        const itemId = item.getAttribute('data-select-item');
        const itemPosition = item.getAttribute('data-item-position');
        const href = link.getAttribute('href');

        fetch('/ajax/select-item', {
          method: 'POST',
          body: JSON.stringify({'id': parseInt(itemId), 'position': parseInt(itemPosition)})
        }).then(() => {
          window.location = href;
        }).catch(() => {
          window.location = href;
        })
      });
    });
  });
}
