export class AsyncEventsHandler {
  constructor(asyncConfig, datalayer, triggers, url) {
    this.asyncConfig = asyncConfig;
    this.datalayer = datalayer;
    this.triggers = triggers;
    this.url = url;
  }

  bindEventListeners() {
    this.triggers.forEach(trigger => {
      document.querySelectorAll(trigger.selector).forEach(element => {
        element.addEventListener(trigger.action, () => {
          this.fetchEvents(trigger, this.asyncConfig.retries);
        });
      });
    });
  }

  async fetchEvents(trigger, attempts = 5) {
    if (attempts === 0) {
      return;
    }

    try {
      const datalayerEvents = await this.doFetchEvents(trigger);
      let events = Object.entries(datalayerEvents);
      if (events.length > 0) {
        events.forEach(([key, event]) => {
          this.datalayer.push({
            event: event.event,
            event_id: event.event_id,
            ecommerce: event
          });
        });
      } else {
        await new Promise(resolve => setTimeout(resolve, this.asyncConfig.timeout));
        await this.fetchEvents(trigger, attempts - 1);
      }
    } catch (error) {
      console.error('Error occurred while fetching events:', error);
    }
  }

  async doFetchEvents(trigger) {
    let headers = new Headers({'X-Requested-With': 'XMLHttpRequest'});
    let formData = new FormData();
    formData.append('dedi_sylius_marketing_async_event', trigger.event);
    const response = await fetch(this.url, {method: 'POST', body: formData, headers: headers});
    if (!response.ok) {
      throw new Error('Something went wrong');
    }
    return response.json();
  }
}

export default AsyncEventsHandler;
