<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Provider;

use Sylius\Component\Core\Model\CustomerInterface;

class UserProvider implements UserProviderInterface
{
    private const HASH_ALGO = 'sha256';

    public function getUserData(?CustomerInterface $customer): array
    {
        if (null === $customer) {
            return [];
        }

        $phoneNumber = $customer->getPhoneNumber() ?? '';
        $email = $customer->getEmail() ?? '';

        return [
            'userId' => $customer->getId(),
            'email' => $email,
            'phone' => $phoneNumber,
            'emailsha' => hash(self::HASH_ALGO, $email),
            'telephonesha' => hash(self::HASH_ALGO, $phoneNumber),
        ];
    }
}
