<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Provider;

use Sylius\Component\Core\Model\ProductInterface;
use Sylius\Component\Core\Model\ProductVariantInterface;
use Sylius\Component\Taxonomy\Model\TaxonInterface;

interface TaxonProviderInterface
{
    public function getCategories(?ProductInterface $product): array;

    public function generateVariantOptions(ProductVariantInterface $variant, bool $isForCart): ?string;

    public function getListTaxonByCurrentUrl(): ?TaxonInterface;

    public function getTaxonBySlug(string $slug): ?TaxonInterface;
}
