<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Provider;

use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Sylius\Component\Core\Model\AdjustmentInterface;
use Sylius\Component\Core\Model\OrderInterface;
use Sylius\Component\Taxation\Model\TaxRate;

class OrderTaxProvider implements OrderTaxProviderInterface
{
    private EntityManagerInterface $entityManager;

    public function __construct(EntityManagerInterface $entityManager)
    {
        $this->entityManager = $entityManager;
    }

    public function isTaxIncluded(?OrderInterface $order): bool
    {
        $isTaxIncluded = false;
        if ($order instanceof OrderInterface) {
            $taxAdjustment = $order->getAdjustmentsRecursively(AdjustmentInterface::TAX_ADJUSTMENT)->first();
            if ($taxAdjustment instanceof AdjustmentInterface) {
                $isTaxIncluded = $taxAdjustment->isNeutral();
            }
        }

        return $isTaxIncluded;
    }

    public function getTaxRateAmount(?OrderInterface $order): ?float
    {
        if (!$order instanceof OrderInterface) {
            return null;
        }

        $adjustment = $order->getAdjustmentsRecursively(AdjustmentInterface::TAX_ADJUSTMENT)->first();

        if (!$adjustment instanceof AdjustmentInterface) {
            return null;
        }

        if (!isset($adjustment->getDetails()['taxRateCode'])) {
            return null;
        }

        /** @var EntityRepository $taxRateRepository */
        $taxRateRepository = $this->entityManager->getRepository(TaxRate::class);

        $taxRate = $taxRateRepository->findOneBy([
            'code' => $adjustment->getDetails()['taxRateCode'],
        ]);

        if (!$taxRate instanceof TaxRate) {
            return null;
        }

        return $taxRate->getAmount();
    }
}
