<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Provider;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Dedi\SyliusMarketingPlugin\DependencyInjection\Settings\SettingsInterface;
use Sylius\Component\Channel\Context\ChannelContextInterface;

class GoogleTagIdProvider implements GoogleTagIdProviderInterface
{
    private ChannelContextInterface $channelContext;

    private SettingsProviderInterface $settingsProvider;

    public function __construct(
        ChannelContextInterface $channelContext,
        SettingsProviderInterface $settingsProvider,
    ) {
        $this->channelContext = $channelContext;
        $this->settingsProvider = $settingsProvider;
    }

    public function provide(): ?string
    {
        /** @var SettingsInterface $settings */
        $settings = $this->settingsProvider->provide();

        foreach ($settings->getChannelIds() as $channelCode => $id) {
            if ($this->channelContext->getChannel()->getCode() === $channelCode) {
                return $id;
            }
        }

        return $settings->getMarketingId();
    }
}
