<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Item;

use Dedi\SyliusMarketingPlugin\Events\Traits\JsonSerialize;

class Item implements \JsonSerializable, ItemInterface
{
    use JsonSerialize;

    private string $item_id;

    private string $item_name;

    private float $price;

    private string $currency;

    private float $discount = 0;

    private int $quantity = 1;

    private ?string $affiliation = null;

    private ?string $coupon = null;

    private ?int $index = null;

    private ?string $item_brand = null;

    private $item_category = [];

    private ?string $item_category2 = null;

    private ?string $item_category3 = null;

    private ?string $item_category4 = '';

    private ?string $item_category5 = null;

    private ?string $item_list_id = null;

    private ?string $item_list_name = null;

    private ?string $item_variant = null;

    private ?string $location_id = null;

    public function getValue(): float
    {
        return ($this->price - $this->discount) * $this->quantity;
    }

    public function getItemId(): string
    {
        return $this->item_id;
    }

    public function setItemId(string $item_id): self
    {
        $this->item_id = $item_id;

        return $this;
    }

    public function getItemName(): string
    {
        return $this->item_name;
    }

    public function setItemName(string $item_name): self
    {
        $this->item_name = $item_name;

        return $this;
    }

    public function getAffiliation(): ?string
    {
        return $this->affiliation;
    }

    public function setAffiliation(?string $affiliation): self
    {
        $this->affiliation = $affiliation;

        return $this;
    }

    public function getCoupon(): ?string
    {
        return $this->coupon;
    }

    public function setCoupon(?string $coupon): self
    {
        $this->coupon = $coupon;

        return $this;
    }

    public function getCurrency(): string
    {
        return $this->currency;
    }

    public function setCurrency(string $currency): self
    {
        $this->currency = $currency;

        return $this;
    }

    public function getDiscount(): ?float
    {
        return $this->discount;
    }

    public function setDiscount(?float $discount): self
    {
        $this->discount = $discount;

        return $this;
    }

    public function getIndex(): ?int
    {
        return $this->index;
    }

    public function setIndex(?int $index): self
    {
        $this->index = $index;

        return $this;
    }

    public function getItemBrand(): ?string
    {
        return $this->item_brand;
    }

    public function setItemBrand(?string $item_brand): self
    {
        $this->item_brand = $item_brand;

        return $this;
    }

    public function getItemCategory()
    {
        return $this->item_category;
    }

    public function setItemCategory($item_category): self
    {
        $this->item_category = $item_category;

        return $this;
    }

    public function getItemCategory2(): ?string
    {
        return $this->item_category2;
    }

    public function setItemCategory2(?string $item_category2): self
    {
        $this->item_category2 = $item_category2;

        return $this;
    }

    public function getItemCategory3(): ?string
    {
        return $this->item_category3;
    }

    public function setItemCategory3(?string $item_category3): self
    {
        $this->item_category3 = $item_category3;

        return $this;
    }

    public function getItemCategory4(): ?string
    {
        return $this->item_category4;
    }

    public function setItemCategory4(?string $item_category4): self
    {
        $this->item_category4 = $item_category4;

        return $this;
    }

    public function getItemCategory5(): ?string
    {
        return $this->item_category5;
    }

    public function setItemCategory5(?string $item_category5): self
    {
        $this->item_category5 = $item_category5;

        return $this;
    }

    public function getItemListId(): ?string
    {
        return $this->item_list_id;
    }

    public function setItemListId(?string $item_list_id): self
    {
        $this->item_list_id = $item_list_id;

        return $this;
    }

    public function getItemListName(): ?string
    {
        return $this->item_list_name;
    }

    public function setItemListName(?string $item_list_name): self
    {
        $this->item_list_name = $item_list_name;

        return $this;
    }

    public function getItemVariant(): ?string
    {
        return $this->item_variant;
    }

    public function setItemVariant(?string $item_variant): self
    {
        $this->item_variant = $item_variant;

        return $this;
    }

    public function getLocationId(): ?string
    {
        return $this->location_id;
    }

    public function setLocationId(?string $location_id): self
    {
        $this->location_id = $location_id;

        return $this;
    }

    public function getPrice(): ?float
    {
        return $this->price;
    }

    public function setPrice(?float $price): self
    {
        $this->price = $price;

        return $this;
    }

    public function getQuantity(): int
    {
        return $this->quantity;
    }

    public function setQuantity(int $quantity): self
    {
        $this->quantity = $quantity;

        return $this;
    }
}
