<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Factory;

use Dedi\SyliusMarketingPlugin\Provider\GoogleTagIdProviderInterface;
use Twig\Environment;

class RenderHeadTwigFactory implements RenderHeadTwigFactoryInterface
{
    private GoogleTagIdProviderInterface $googleTagProvider;

    private Environment $twig;

    private string $additionalParams;

    private string $templateName;

    private bool $enabled;

    public function __construct(
        GoogleTagIdProviderInterface $googleTagProvider,
        Environment $twig,
        string $additionalParams,
        string $templateName,
        bool $enabled,
    ) {
        $this->googleTagProvider = $googleTagProvider;
        $this->twig = $twig;
        $this->templateName = $templateName;
        $this->enabled = $enabled;
        $this->additionalParams = '&' . trim($additionalParams, '&');
    }

    public function render(): string
    {
        return !$this->enabled ? '' : $this->twig->render(
            $this->templateName,
            [
                'id' => $this->googleTagProvider->provide(),
                'url_suffix' => $this->additionalParams,
            ],
        );
    }
}
