<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Factory;

use Dedi\SyliusMarketingPlugin\Item\ItemInterface;
use Sylius\Component\Core\Model\OrderItemInterface;
use Sylius\Component\Core\Model\ProductInterface;
use Sylius\Component\Core\Model\ProductVariantInterface;

interface ItemFactoryInterface
{
    public function fromProductVariant(
        ProductVariantInterface $variant,
        bool $isForCart = false,
        ?int $position = null,
        string $itemListId = null,
        string $itemListName = null,
    ): ItemInterface;

    public function fromProduct(
        ProductInterface $product,
        ?int $position = null,
        string $itemListId = null,
        string $itemListName = null,
    ): ItemInterface;

    public function fromOrderItem(OrderItemInterface $orderItem): ItemInterface;
}
