<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Factory\Events;

use Dedi\SyliusMarketingPlugin\ControllerEvent\SelectItemEvent;
use Dedi\SyliusMarketingPlugin\Events\Search;
use Dedi\SyliusMarketingPlugin\Events\SelectItem;
use Dedi\SyliusMarketingPlugin\Events\ViewItem;
use Dedi\SyliusMarketingPlugin\Events\ViewItemList;
use Sylius\Component\Core\Model\ProductInterface;

interface NavigationEventFactoryInterface
{
    public function search(string $searchTerm): Search;

    public function viewItemList(array $products = []): ViewItemList;

    public function viewItem(ProductInterface $product): ViewItem;

    public function selectItem(SelectItemEvent $selectItemEvent): SelectItem;
}
