<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Factory\Events;

use Dedi\SyliusMarketingPlugin\Events\AddAddressInfo;
use Dedi\SyliusMarketingPlugin\Events\AddPaymentInfo;
use Dedi\SyliusMarketingPlugin\Events\AddShippingInfo;
use Dedi\SyliusMarketingPlugin\Events\BeginCheckout;
use Dedi\SyliusMarketingPlugin\Events\Purchase;
use Sylius\Component\Core\Model\Order;

interface CheckoutEventFactoryInterface
{
    public function beginCheckout(): BeginCheckout;

    public function addAddressInfo(): AddAddressInfo;

    public function addPaymentInfo(): AddPaymentInfo;

    public function addShippingInfo(): AddShippingInfo;

    public function purchase(Order $order): Purchase;
}
