<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Factory\Events;

use Dedi\SyliusMarketingPlugin\Events\AddToCart;
use Dedi\SyliusMarketingPlugin\Events\RemoveFromCart;
use Dedi\SyliusMarketingPlugin\Events\ViewCart;
use Sylius\Component\Core\Model\OrderItemInterface;
use Sylius\Component\Order\Model\OrderInterface;

interface CartEventFactoryInterface
{
    public function addToCart(OrderItemInterface $orderItem): AddToCart;

    public function viewCart(): ViewCart;

    public function removeFromCart(OrderItemInterface $orderItem): RemoveFromCart;

    public function clearCart(OrderInterface $order): RemoveFromCart;
}
