<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Factory\Events;

use Dedi\SyliusMarketingPlugin\Events\AddToCart;
use Dedi\SyliusMarketingPlugin\Events\RemoveFromCart;
use Dedi\SyliusMarketingPlugin\Events\ViewCart;
use Dedi\SyliusMarketingPlugin\Factory\ItemFactoryInterface;
use Sylius\Component\Core\Model\OrderItemInterface;
use Sylius\Component\Order\Context\CartContextInterface;
use Sylius\Component\Order\Model\OrderInterface;

class CartEventFactory implements CartEventFactoryInterface
{
    private ItemFactoryInterface $itemFactory;

    private CartContextInterface $cartContext;

    public function __construct(ItemFactoryInterface $itemFactory, CartContextInterface $cartContext)
    {
        $this->itemFactory = $itemFactory;
        $this->cartContext = $cartContext;
    }

    public function addToCart(OrderItemInterface $orderItem): AddToCart
    {
        $addToCart = new AddToCart();
        $addToCart->addItem(
            $this->itemFactory->fromOrderItem($orderItem),
        );

        return $addToCart;
    }

    public function viewCart(): ViewCart
    {
        $viewCart = new ViewCart();
        foreach ($this->cartContext->getCart()->getItems() as $orderItem) {
            $viewCart->addItem(
                $this->itemFactory->fromOrderItem($orderItem),
            );
        }

        return $viewCart;
    }

    public function removeFromCart(OrderItemInterface $orderItem): RemoveFromCart
    {
        $removeFromCart = new RemoveFromCart();
        $removeFromCart->addItem(
            $this->itemFactory->fromOrderItem($orderItem),
        );

        return $removeFromCart;
    }

    public function clearCart(OrderInterface $order): RemoveFromCart
    {
        $removeFromCart = new RemoveFromCart();
        foreach ($order->getItems() as $item) {
            $removeFromCart->addItem(
                $this->itemFactory->fromOrderItem($item),
            );
        }

        return $removeFromCart;
    }
}
