<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Factory\Events;

use Dedi\SyliusMarketingPlugin\Events\Login;
use Dedi\SyliusMarketingPlugin\Events\Signup;

class AuthEventFactory implements AuthEventFactoryInterface
{
    public function login(?string $method = null): Login
    {
        return (new Login())
            ->setMethod($method)
        ;
    }

    public function signup(?string $method = null): Signup
    {
        return (new Signup())
            ->setMethod($method)
        ;
    }
}
