<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Extractor;

use Pagerfanta\Pagerfanta;
use Sylius\Bundle\ResourceBundle\Controller\RequestConfigurationFactoryInterface;
use Sylius\Bundle\ResourceBundle\Controller\ResourcesCollectionProviderInterface;
use Sylius\Bundle\ResourceBundle\Grid\View\ResourceGridView;
use Sylius\Component\Core\Repository\ProductRepositoryInterface;
use Sylius\Component\Resource\Metadata\RegistryInterface;
use Symfony\Component\HttpKernel\Event\ControllerArgumentsEvent;
use Symfony\Contracts\EventDispatcher\Event;

class RequestProductExtractor implements RequestProductExtractorInterface
{
    private RequestConfigurationFactoryInterface $requestConfigurationFactory;

    private ResourcesCollectionProviderInterface $resourcesCollectionProvider;

    private ProductRepositoryInterface $productRepository;

    private RegistryInterface $registry;

    public function __construct(
        RequestConfigurationFactoryInterface $requestConfigurationFactory,
        ResourcesCollectionProviderInterface $resourcesCollectionProvider,
        ProductRepositoryInterface $productRepository,
        RegistryInterface $registry,
    ) {
        $this->requestConfigurationFactory = $requestConfigurationFactory;
        $this->resourcesCollectionProvider = $resourcesCollectionProvider;
        $this->productRepository = $productRepository;
        $this->registry = $registry;
    }

    public function extract(Event $event): array
    {
        $products = [];

        if (!$event instanceof ControllerArgumentsEvent) {
            return $products;
        }

        $metadata = $this->registry->get('sylius.taxon');
        $request = $event->getRequest();
        $configuration = $this->requestConfigurationFactory->create($metadata, $request);
        $resources = $this->resourcesCollectionProvider->get($configuration, $this->productRepository);

        if (!$resources instanceof ResourceGridView) {
            return $products;
        }

        $data = $resources->getData();

        if (!$data instanceof Pagerfanta) {
            return $products;
        }

        $currentPageResults = $data->getCurrentPageResults();

        if (count($currentPageResults) === 0) {
            return $products;
        }

        return iterator_to_array($currentPageResults);
    }
}
