<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events;

use Dedi\SyliusMarketingPlugin\Events\Traits\ItemContainer;
use Dedi\SyliusMarketingPlugin\Events\Traits\JsonSerialize;
use Dedi\SyliusMarketingPlugin\Item\ItemInterface;

class ViewItemList extends AbstractEvent implements ItemsContainerInterface
{
    use JsonSerialize;
    use ItemContainer;

    private ?string $item_list_id = null;

    private ?string $item_list_name = null;

    public function getName(): string
    {
        return 'view_item_list';
    }

    public function setItemListId(?string $item_list_id): self
    {
        $this->item_list_id = $item_list_id;

        return $this;
    }

    public function setItemListName(?string $item_list_name): self
    {
        $this->item_list_name = $item_list_name;

        return $this;
    }

    /**
     * @inheritDoc
     */
    protected function calculate(ItemInterface $item): void
    {
    }
}
