<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events\Traits;

trait JsonSerialize
{
    public function __toString(): string
    {
        return json_encode($this, \JSON_THROW_ON_ERROR);
    }

    public function jsonSerialize(): array
    {
        $result = [];
        foreach (get_object_vars($this) as $key => $value) {
            if ($value instanceof \JsonSerializable) {
                $result[$key] = $value->jsonSerialize();
            } elseif (null !== $value) {
                $result[$key] = $value;
            }
        }

        return $result;
    }
}
