<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events\Traits;

use Dedi\SyliusMarketingPlugin\Exception\CurrencyMismatchException;
use Dedi\SyliusMarketingPlugin\Item\ItemInterface;

trait ItemContainer
{
    protected ?string $currency = null;

    protected ?float $value = null;

    protected array $items = [];

    /**
     * @throws CurrencyMismatchException
     */
    public function addItem(ItemInterface $item): self
    {
        $this->calculate($item);
        $this->items[] = $item;

        return $this;
    }

    /**
     * @throws CurrencyMismatchException
     */
    protected function calculate(ItemInterface $item): void
    {
        if ($this->currency === null && count($this->items) === 0) {
            $this->currency = $item->getCurrency();
        }

        if ($item->getCurrency() !== $this->currency) {
            throw new CurrencyMismatchException();
        }

        $this->value = round((float) $this->value + $item->getValue(), 2);
    }

    public function setTotal(?float $total): self
    {
        $this->value = $total;

        return $this;
    }
}
