<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events;

use Dedi\SyliusMarketingPlugin\Events\Traits\JsonSerialize;

class SpendVirtualCurrency extends AbstractEvent
{
    use JsonSerialize;

    private string $virtual_currency_name;

    private float $value;

    private ?string $item_name = null;

    public function __construct(string $virtual_currency_name, float $value)
    {
        $this->virtual_currency_name = $virtual_currency_name;
        $this->value = $value;
    }

    public function getName(): string
    {
        return 'spend_virtual_currency';
    }

    public function setItemName(string $item_name): self
    {
        $this->item_name = $item_name;

        return $this;
    }
}
