<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events;

use Dedi\SyliusMarketingPlugin\Events\Traits\ItemContainer;
use Dedi\SyliusMarketingPlugin\Events\Traits\JsonSerialize;

class SelectPromotion extends AbstractEvent implements ItemsContainerInterface
{
    use JsonSerialize;
    use ItemContainer;

    private ?string $creative_name = null;

    private ?string $creative_slot = null;

    private ?string $location_id = null;

    private ?string $promotion_id = null;

    private ?string  $promotion_name = null;

    public function getName(): string
    {
        return 'select_promotion';
    }

    public function setCreativeName(?string $creative_name): self
    {
        $this->creative_name = $creative_name;

        return $this;
    }

    public function setCreativeSlot(?string $creative_slot): self
    {
        $this->creative_slot = $creative_slot;

        return $this;
    }

    public function setLocationId(?string $location_id): self
    {
        $this->location_id = $location_id;

        return $this;
    }

    public function setPromotionId(?string $promotion_id): self
    {
        $this->promotion_id = $promotion_id;

        return $this;
    }

    public function setPromotionName(?string $promotion_name): self
    {
        $this->promotion_name = $promotion_name;

        return $this;
    }
}
