<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events;

use Dedi\SyliusMarketingPlugin\Events\Traits\JsonSerialize;

class SelectContent extends AbstractEvent
{
    use JsonSerialize;

    private ?string $content_type = null;

    private ?string $item_id = null;

    public function getName(): string
    {
        return 'select_content';
    }

    public function setContentType(?string $content_type): self
    {
        $this->content_type = $content_type;

        return $this;
    }

    public function setItemId(?string $item_id): self
    {
        $this->item_id = $item_id;

        return $this;
    }
}
