<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events;

use Dedi\SyliusMarketingPlugin\Events\Traits\JsonSerialize;

class Search extends AbstractEvent
{
    use JsonSerialize;

    private string $search_term;

    public function __construct(string $search_term)
    {
        $this->search_term = $search_term;
    }

    public function getName(): string
    {
        return 'search';
    }
}
