<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events;

use Dedi\SyliusMarketingPlugin\Events\Traits\JsonSerialize;

class Refund extends AbstractEvent
{
    use JsonSerialize;

    private string $transaction_id;

    private ?string $affiliation = null;

    private ?string $coupon = null;

    private ?float $shipping = null;

    private ?float $tax = null;

    public function __construct(string $transaction_id)
    {
        $this->transaction_id = $transaction_id;
    }

    public function getName(): string
    {
        return 'refund';
    }

    public function setAffiliation(?string $affiliation): self
    {
        $this->affiliation = $affiliation;

        return $this;
    }

    public function setCoupon(?string $coupon): self
    {
        $this->coupon = $coupon;

        return $this;
    }

    public function setShipping(?float $shipping): self
    {
        $this->shipping = $shipping;

        return $this;
    }

    public function setTax(?float $tax): self
    {
        $this->tax = $tax;

        return $this;
    }
}
