<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events;

use Dedi\SyliusMarketingPlugin\Events\Traits\JsonSerialize;

class PostScore extends AbstractEvent
{
    use JsonSerialize;

    private float $score;

    private ?float $level = null;

    private ?string $character = null;

    public function __construct(float $score)
    {
        $this->score = $score;
    }

    public function getName(): string
    {
        return 'post_score';
    }

    public function setLevel(?float $level): self
    {
        $this->level = $level;

        return $this;
    }

    public function setCharacter(?string $character): self
    {
        $this->character = $character;

        return $this;
    }
}
