<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events;

use Dedi\SyliusMarketingPlugin\Events\Traits\JsonSerialize;

class LevelUp extends AbstractEvent
{
    use JsonSerialize;

    private ?float $level = null;

    private ?string $character = null;

    public function getName(): string
    {
        return 'level_up';
    }

    public function setLevel(?float $level): self
    {
        $this->level = $level;

        return $this;
    }

    public function setCharacter(?string $character): self
    {
        $this->character = $character;

        return $this;
    }
}
