<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events;

use Dedi\SyliusMarketingPlugin\Events\Traits\JsonSerialize;

class LevelStart extends AbstractEvent
{
    use JsonSerialize;

    private ?string $level_name = null;

    public function getName(): string
    {
        return 'level_start';
    }

    public function setLevelName(?string $level_name): self
    {
        $this->level_name = $level_name;

        return $this;
    }
}
