<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events;

use Dedi\SyliusMarketingPlugin\Events\Traits\JsonSerialize;

class LevelEnd extends AbstractEvent
{
    use JsonSerialize;

    private ?string $level_name = null;

    private ?bool $success = null;

    public function getName(): string
    {
        return 'level_end';
    }

    public function setLevelName(?string $level_name): self
    {
        $this->level_name = $level_name;

        return $this;
    }

    public function setSuccess(?bool $success): self
    {
        $this->success = $success;

        return $this;
    }
}
