<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events;

use Dedi\SyliusMarketingPlugin\Events\Traits\JsonSerialize;

class GenerateLead extends AbstractEvent
{
    use JsonSerialize;

    private string $currency;

    private float $value;

    public function __construct(string $currency = 'USD', float $value = 0)
    {
        $this->currency = $currency;
        $this->value = $value;
    }

    public function getName(): string
    {
        return 'generate_lead';
    }
}
