<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events;

use Dedi\SyliusMarketingPlugin\Events\Traits\JsonSerialize;

class EarnVirtualCurrency extends AbstractEvent
{
    use JsonSerialize;

    private ?string $virtual_currency_name = null;

    private ?float $value = null;

    public function getName(): string
    {
        return 'earn_virtual_currency';
    }

    public function setVirtualCurrencyName(?string $virtual_currency_name): self
    {
        $this->virtual_currency_name = $virtual_currency_name;

        return $this;
    }

    public function setValue(?float $value): self
    {
        $this->value = $value;

        return $this;
    }
}
