<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events;

use Dedi\SyliusMarketingPlugin\Events\Traits\ItemContainer;
use Dedi\SyliusMarketingPlugin\Events\Traits\JsonSerialize;

class BeginCheckout extends AbstractEvent implements ItemsContainerInterface
{
    use JsonSerialize;
    use ItemContainer;

    private ?string $coupon = null;

    public function getName(): string
    {
        return 'begin_checkout';
    }

    public function setCoupon(?string $coupon): self
    {
        $this->coupon = $coupon;

        return $this;
    }
}
