<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events;

use Dedi\SyliusMarketingPlugin\Events\Traits\ItemContainer;
use Dedi\SyliusMarketingPlugin\Events\Traits\JsonSerialize;

class AddShippingInfo extends AbstractEvent implements ItemsContainerInterface
{
    use JsonSerialize;
    use ItemContainer;

    private ?string $coupon = null;

    private ?string $shipping_tier = null;

    public function getName(): string
    {
        return 'add_shipping_info';
    }

    public function setCoupon(?string $coupon): self
    {
        $this->coupon = $coupon;

        return $this;
    }

    public function setShippingTier(?string $shipping_tier): self
    {
        $this->shipping_tier = $shipping_tier;

        return $this;
    }
}
