<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events;

use Dedi\SyliusMarketingPlugin\Events\Traits\ItemContainer;
use Dedi\SyliusMarketingPlugin\Events\Traits\JsonSerialize;

class AddPaymentInfo extends AbstractEvent implements ItemsContainerInterface
{
    use JsonSerialize;
    use ItemContainer;

    private ?string $coupon = null;

    private ?string $payment_type = null;

    public function getName(): string
    {
        return 'add_payment_info';
    }

    public function setCoupon(?string $coupon): self
    {
        $this->coupon = $coupon;

        return $this;
    }

    public function setPaymentType(?string $payment_type): self
    {
        $this->payment_type = $payment_type;

        return $this;
    }
}
