<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\Events;

abstract class AbstractEvent implements \JsonSerializable, EventInterface
{
    // Those properties are protected to be able to serialize them
    protected ?string $event = null;

    // Special naming convention for serialization purpose
    protected ?string $event_id = null;

    abstract public function getName(): string;

    public function getUniqId(): string
    {
        // Trick to have the name in the serialization
        if (null === $this->event) {
            $this->event = $this->getName();
        }
        if (null === $this->event_id) {
            $this->event_id = uniqid($this->getName() . '_', true);
        }

        return $this->event_id;
    }
}
