<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\EventListener;

use Dedi\SyliusMarketingPlugin\Factory\RenderHeadTwigFactoryInterface;
use Symfony\Component\HttpKernel\Event\ResponseEvent;

class RenderViewListener extends MarketingListener
{
    private RenderHeadTwigFactoryInterface $renderTwig;

    public function __construct(RenderHeadTwigFactoryInterface $renderTwig)
    {
        $this->renderTwig = $renderTwig;
    }

    public function onKernelResponse(ResponseEvent $event): void
    {
        if (!$this->isAllowed($event)) {
            return;
        }

        if (!$this->isEnabled()) {
            return;
        }

        $event->getResponse()->setContent(
            preg_replace(
                '/<head\b[^>]*>/',
                '$0' . $this->renderTwig->render(),
                (string) $event->getResponse()->getContent(),
                1,
            ),
        );
    }

    private function isAllowed(ResponseEvent $event): bool
    {
        $contentType = $event->getResponse()->headers->get('content-type');

        return in_array($contentType, ['text/html', null], true) &&
            null === $event->getResponse()->headers->get('location') &&
            $event->isMainRequest();
    }
}
