<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\EventListener;

use Dedi\SyliusMarketingPlugin\Factory\Events\NewsletterEventFactoryInterface;
use Dedi\SyliusMarketingPlugin\Storage\EventsStorage;
use Doctrine\ORM\Event\PreUpdateEventArgs;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use Sylius\Component\Core\Model\CustomerInterface;

class NewsletterEventListener extends MarketingListener
{
    private EventsStorage $eventsStorage;

    private NewsletterEventFactoryInterface $newsletterEventFactory;

    public function __construct(EventsStorage $eventsStorage, NewsletterEventFactoryInterface $newsletterEventFactory)
    {
        $this->eventsStorage = $eventsStorage;
        $this->newsletterEventFactory = $newsletterEventFactory;
    }

    public function prePersist(LifecycleEventArgs $event): void
    {
        $object = $event->getObject();

        if (!$object instanceof CustomerInterface) {
            return;
        }

        if (!$this->isEnabled()) {
            return;
        }

        if ($object->isSubscribedToNewsletter()) {
            $this->eventsStorage->store(
                $this->newsletterEventFactory->createFromNewsletterEvent(),
            );
        }
    }

    public function preUpdate(LifecycleEventArgs $event): void
    {
        $object = $event->getObject();

        if (!$object instanceof CustomerInterface) {
            return;
        }

        if (!$event instanceof PreUpdateEventArgs) {
            return;
        }

        if (!$this->isEnabled()) {
            return;
        }

        $changeSet = $event->getEntityChangeSet();

        if (!isset($changeSet['subscribedToNewsletter'])) {
            return;
        }

        if (false === $changeSet['subscribedToNewsletter'][0] && true === $changeSet['subscribedToNewsletter'][1]) {
            $this->eventsStorage->store(
                $this->newsletterEventFactory->createFromNewsletterEvent(),
            );
        }
    }
}
