<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\EventListener;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Dedi\SyliusMarketingPlugin\DependencyInjection\Settings\SettingsInterface;

abstract class MarketingListener implements MarketingListenerInterface
{
    private ?SettingsProviderInterface $settingsProvider = null;

    public function isEnabled(): bool
    {
        if (null === $this->settingsProvider) {
            throw new \RuntimeException('Settings provider is not set');
        }

        try {
            /** @var SettingsInterface $settings */
            $settings = $this->settingsProvider->provide();

            return $settings->isEnabled();
        } catch (\Throwable $e) {
            return false;
        }
    }

    public function setSettingsProvider(SettingsProviderInterface $settingsProvider): void
    {
        $this->settingsProvider = $settingsProvider;
    }
}
