<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\EventListener;

use Dedi\SyliusMarketingPlugin\Factory\Events\CartEventFactoryInterface;
use Dedi\SyliusMarketingPlugin\Storage\EventsStorage;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use Sylius\Component\Order\Model\OrderInterface;

class CartDoctrineEventListener extends MarketingListener
{
    private EventsStorage $eventsStorage;

    private CartEventFactoryInterface $cartEventFactory;

    public function __construct(EventsStorage $eventsStorage, CartEventFactoryInterface $cartEventFactory)
    {
        $this->eventsStorage = $eventsStorage;
        $this->cartEventFactory = $cartEventFactory;
    }

    public function preRemove(LifecycleEventArgs $event): void
    {
        $object = $event->getObject();

        if (!$object instanceof OrderInterface || OrderInterface::STATE_CART !== $object->getState()) {
            return;
        }

        if (!$this->isEnabled()) {
            return;
        }

        $this->eventsStorage->store(
            $this->cartEventFactory->clearCart($object),
        );
    }
}
