<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\EventListener;

use Dedi\SyliusMarketingPlugin\Factory\Events\AuthEventFactoryInterface;
use Dedi\SyliusMarketingPlugin\Storage\EventsStorage;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\EventDispatcher\GenericEvent;
use Symfony\Component\Security\Http\Event\InteractiveLoginEvent;
use Symfony\Contracts\EventDispatcher\Event;

class AuthEventListener extends MarketingListener implements EventSubscriberInterface
{
    private AuthEventFactoryInterface $authEventFactory;

    private EventsStorage $eventsStorage;

    public function __construct(AuthEventFactoryInterface $authEventFactory, EventsStorage $eventsStorage)
    {
        $this->authEventFactory = $authEventFactory;
        $this->eventsStorage = $eventsStorage;
    }

    public static function getSubscribedEvents(): array
    {
        return [
            'sylius.user.security.implicit_login' => 'login',
            'security.interactive_login' => 'loginInteractive',
            'sylius.customer.post_register' => 'signup',
            'sylius.shop_user.post_create' => 'signup',
        ];
    }

    public function signup(GenericEvent $event): void
    {
        if (!$this->isEnabled()) {
            return;
        }

        $this->eventsStorage->store(
            $this->authEventFactory->signup(),
        );
    }

    //Two different types of events are catch for register redirect and login
    public function login(Event $event): void
    {
        if (!$this->isEnabled()) {
            return;
        }

        $this->eventsStorage->store(
            $this->authEventFactory->login(),
        );
    }

    public function loginInteractive(InteractiveLoginEvent $event): void
    {
        if (!$this->isEnabled()) {
            return;
        }

        $this->eventsStorage->store(
            $this->authEventFactory->login(),
        );
    }
}
