<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\DependencyInjection\Settings;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;

class SettingsProvider implements SettingsProviderInterface
{
    private SettingsInterface $settings;

    public function __construct(SettingsInterface $settings)
    {
        $this->settings = $settings;
    }

    public function provide(bool $default = false): SettingsInterface
    {
        return $this->settings;
    }

    public function getName(): string
    {
        return 'dedi_marketing_plugin';
    }
}
