<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\DependencyInjection\Settings;

class Settings implements SettingsInterface
{
    private bool $enabled;

    private string $marketingId;

    private string $additionalParameters;

    private array $channelIds;

    private array $asyncTriggers;

    private ?array $asyncEvents = null;

    private bool $asyncReloaded;

    private array $asyncConfig;

    public function __construct(
        bool $enabled,
        string $marketingId,
        string $additionalParameters,
        array $channelIds,
        array $asyncTriggers,
        bool $asyncReloaded,
        array $asyncConfig,
    ) {
        $this->enabled = $enabled;
        $this->marketingId = $marketingId;
        $this->additionalParameters = $additionalParameters;
        $this->channelIds = $channelIds;
        $this->asyncTriggers = $asyncTriggers;
        $this->asyncReloaded = $asyncReloaded;
        $this->asyncConfig = $asyncConfig;
    }

    public function isEnabled(): bool
    {
        return $this->enabled;
    }

    public function getMarketingId(): string
    {
        return $this->marketingId;
    }

    public function getAdditionalParameters(): string
    {
        return $this->additionalParameters;
    }

    public function getChannelIds(): array
    {
        return $this->channelIds;
    }

    public function getAsyncEvents(): array
    {
        if (null === $this->asyncEvents) {
            $this->asyncEvents = array_column($this->asyncTriggers, 'event');
        }

        return $this->asyncEvents;
    }

    public function getAsyncTriggers(): array
    {
        return $this->asyncTriggers;
    }

    public function isAsyncReloaded(): bool
    {
        return $this->asyncReloaded;
    }

    public function getAsyncConfig(): array
    {
        return $this->asyncConfig;
    }
}
