<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\DependencyInjection;

use Symfony\Component\Config\Definition\ConfigurationInterface;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\XmlFileLoader;

final class DediSyliusMarketingExtension extends Extension
{
    public function load(array $configs, ContainerBuilder $container): void
    {
        $config = $this->processConfiguration($this->getConfiguration([], $container), $configs);
        $loader = new XmlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.xml');

        $settingsDefinition = $container->getDefinition('dedi_sylius_marketing.settings');
        $settingsDefinition->setArgument('$enabled', $config['enabled']);
        $settingsDefinition->setArgument('$marketingId', $config['marketing_id'] ?? '');
        $settingsDefinition->setArgument('$additionalParameters', $config['additional_parameters'] ?? '');
        $settingsDefinition->setArgument('$channelIds', $config['channel_ids'] ?? []);
        $settingsDefinition->setArgument('$asyncTriggers', $config['async_triggers'] ?? []);
        $settingsDefinition->setArgument('$asyncReloaded', $config['async_reloaded']);
        $settingsDefinition->setArgument('$asyncConfig', $config['async_config']);
    }

    public function getConfiguration(array $config, ContainerBuilder $container): ConfigurationInterface
    {
        return new Configuration();
    }

    public function getAlias(): string
    {
        return 'dedi_sylius_marketing';
    }
}
