<?php

declare(strict_types=1);

namespace Dedi\SyliusMarketingPlugin\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

final class Configuration implements ConfigurationInterface
{
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('dedi_sylius_marketing');
        $rootNode = $treeBuilder->getRootNode();

        $rootNode
            ->children()
            ->scalarNode('marketing_id')->defaultNull()->end()
            ->booleanNode('enabled')->defaultTrue()->end()
            ->scalarNode('additional_parameters')->defaultValue('')->end()
            ->arrayNode('channel_ids')->canBeUnset()->useAttributeAsKey('code')->prototype('scalar')->end()->end()
            ->arrayNode('async_triggers')->defaultValue([])
                ->arrayPrototype()
                ->children()
                    ->scalarNode('action')->end()
                    ->scalarNode('selector')->end()
                    ->scalarNode('event')->end()
            ->end()->end()->end()
            ->booleanNode('async_reloaded')->defaultFalse()->end()
            ->arrayNode('async_config')->addDefaultsIfNotSet()
            ->children()
                ->scalarNode('timeout')->defaultValue(1000)->end()
                ->scalarNode('retries')->defaultValue(5)->end()
            ->end()->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
